import math
import os.path
import re
import subprocess
import tempfile
from myutil import *
import trees

class FScore(object):
    def __init__(self, recall, precision, fscore, seg_f1, pos_f1):
        self.recall = recall
        self.precision = precision
        self.fscore = fscore
        self.seg_f1 = seg_f1
        self.pos_f1 = pos_f1

    def __str__(self):
        return "(Recall={:.2f}, Precision={:.2f}, FScore={:.2f}, Seg_F1={:.2f}, Pos_F1={:.2f})".format(
            self.recall, self.precision, self.fscore, self.seg_f1, self.pos_f1)

def evalb(evalb_dir, gold_trees, predicted_trees, ref_gold_path=None):
    assert len(gold_trees) == len(predicted_trees)

    for gold_tree, predicted_tree in zip(gold_trees, predicted_trees):
        assert isinstance(gold_tree, trees.TreebankNode)
        assert isinstance(predicted_tree, trees.TreebankNode)
        gold_leaves = list(gold_tree.leaves())
        predicted_leaves = list(predicted_tree.leaves())
        assert len(gold_leaves) == len(predicted_leaves)
        assert all(
            gold_leaf.word == predicted_leaf.word
            for gold_leaf, predicted_leaf in zip(gold_leaves, predicted_leaves))

    gold_trees_str = []
    pred_trees_str = []
    for tree in gold_trees:
        gold_trees_str.append(my_convert_char_backward(tree.linearize()))
    for tree in predicted_trees:
        pred_trees_str.append(my_convert_char_backward(tree.linearize()))

    pos_prf, seg_prf, cst_prf, spn_prf = MyEvaluation.evaluate(gold_trees_str, pred_trees_str)

    fscore = FScore(math.nan, math.nan, math.nan, math.nan, math.nan)
    fscore.recall = cst_prf[1]*100.
    fscore.precision = cst_prf[0]*100.
    fscore.fscore = cst_prf[2]*100.
    fscore.seg_f1 = seg_prf[2]*100.
    fscore.pos_f1 = pos_prf[2]*100.

    return fscore
